#include "reseau.h"

int ecouter_joueur(void *param); //Lance une boucle d'coute sur un joueur

long res_init(t_reseau *res)
{
    if (SDLNet_Init() == -1) {return 0;}//Initialise SDL_net pour le rseau
    res->nbr_joueurs = 0; //Puisque c'est l'initialisation, il n'y a pas de joueurs connect
    res->port = PORT;
    res->ecoute = 0;
    res->pseudo = NULL;
    res->chargee = 0;
    if(!changer_nbr_joueurs(res, 0)) {return 0;}
    return 1;
}

void res_quit(t_reseau *res)
{
    changer_nbr_joueurs(res, 0); //On libre la mmoire alloue pour les clients
    if(res->ecoute) {SDLNet_TCP_Close(res->serveur);} //On arrte l'coute si c'est ncessaire
    SDLNet_Quit();
}

long changer_nbr_joueurs(t_reseau *res, long nbr)
{
    long i;

    if(res->nbr_joueurs != 0)
    {
        for(i = 0; i < res->nbr_joueurs; i++) {supprimer_joueur(res, i);} //On dconnecte chaque client et on supprime la mmoire alloue  ceux-ci
        free(res->joueurs); //On libre ce qu'il reste de mmoire pour les joueurs
    }
    if(res->pseudo) //On supprime les prcdents pseudo
    {
        for(i = 0; i < res->nbr_joueurs; i++)
        {
            if(res->pseudo[i]) {free(res->pseudo[i]);}
        }
        free(res->pseudo);
    }

    //On construit une nouvelle structure pour les joueurs
    res->nbr_joueurs = nbr;
    if(nbr != 0)
    {
        res->joueurs = (t_joueur *)malloc(nbr * sizeof(t_joueur));
        if(res->joueurs == NULL) {return 0;}
        res->pseudo = (char **)malloc(nbr * sizeof(char *));
        if(res->pseudo == NULL) {return 0;}
        for(i = 0; i < nbr; i++)
        {
            res->joueurs[i].socket = NULL;
            res->pseudo[i] = NULL;
            res->joueurs[i].paquets = NULL;
            res->joueurs[i].thread_id = NULL;
            res->joueurs[i].ecoute = -1;
            res->joueurs[i].pret = 0;
            res->joueurs[i].campeur = 0;
        }
    }
    return 1;
}

long lancer_serveur(TCPsocket *serveur, IPaddress *adresse_serveur, long port)
{
    if(SDLNet_ResolveHost(adresse_serveur, NULL, port) == -1) {return 0;}//Rsolution dns
    *serveur = SDLNet_TCP_Open(adresse_serveur); //Ouverture en coute
    if(*serveur == NULL) {return 0;}
    return 1;
}

long nouveaux_joueurs(t_reseau *res, t_affichage *aff)
{
    char buffer[BUFFER_MAX]; //Tampon pour le texte format
    long i, verif;
    TCPsocket autre;

    do
    {
        verif = 0;
        if(res->nbr_clients < res->nbr_joueurs) //Si tous les joueurs n'ont pas rejoint la partie
        {
            i = 0;
            while((res->joueurs[i].socket != NULL) && i < res->nbr_joueurs) {i++;} //On recherche la premire place libre
            if(!accepter_joueur(&(res->joueurs[i]), res->serveur)) {return 0;}//On alloue  cette place libre le nouveau client potentiel
            if(res->joueurs[i].socket != NULL) //On vrifie si un nouveau client s'est connect
            {
                res->nbr_clients++;
                sprintf(buffer, "Un client s'est connect (affect au joueur n%ld) !", i + 1);
                afficher_message(aff->ecran, buffer, aff->police_normale, 255, 255, 0);
                verif = 1;
            }
        }
        else //Si le serveur est plein
        {
            while((autre = SDLNet_TCP_Accept(res->serveur)) != NULL) //Tant que d'autres clients se connectent
            {
                SDLNet_TCP_Close(autre); //On les dconnecte car le serveur est plein
            }
        }
    }while(verif); //Tant qu'on a pas pris en compte toutes les nouvelles connexions
    return 1;
}

long accepter_joueur(t_joueur *joueur, TCPsocket serveur)
{
    joueur->socket = SDLNet_TCP_Accept(serveur); //S'il y a une connexion, on l'accepte
    if(joueur->socket != NULL) //Si on a accept une connexion
    {
        joueur->paquets = (t_paquet *)malloc(sizeof(t_paquet)); //On prpare un emplacement mmoire pour la rception de messages
        if(joueur->paquets == NULL) {return 0;}
        joueur->paquets->taille = 0;
        joueur->paquets->suivant = NULL;
        joueur->pret = 0;
        joueur->thread_id = SDL_CreateThread(ecouter_joueur, joueur); //On lance le thread d'coute
        joueur->ecoute = 1;
    }
    return 1;
}

int ecouter_joueur(void *param)
{
    t_joueur *j; //Contient les infos du joueur sur coute
    t_paquet *paquet, *prec; //Contient les paquets prcdent et en rception
    char temp[8]; //Contient l'en-tte du paquet en rception

    j = (t_joueur *)param; //On rcupre les donnes dans une structure
    prec = j->paquets; //Initialisation de la liste des paquets
    while(SDLNet_TCP_Recv(j->socket, temp, 8) > 0) //Tant qu'il n'y a pas eu de dconnexion ou d'erreur, on lit l'en-tte du paquet
    {
        paquet = (t_paquet *)malloc(sizeof(t_paquet)); //On prpare la mmoire pour recevoir un autre paquet
        if(paquet == NULL)
        {
            j->ecoute = 0;
            return 1;
        }
        paquet->type = SDLNet_Read32(temp); //On en rcupre le type
        paquet->taille = SDLNet_Read32(temp + 4); //La taille
        paquet->suivant = NULL; //On n'a pas encore rcupr d'autres paquets
        if(paquet->taille != 0) //S'il reste des donnes  rcuprer
        {
            paquet->donnee = (char *)malloc(paquet->taille); //On alloue alors assez de mmoire pour le corps
            if(paquet->donnee == NULL)
            {
                free(paquet);
                j->ecoute = 0;
                return 1;
            }
            SDLNet_TCP_Recv(j->socket, paquet->donnee, paquet->taille); //On rcupre enfin le corps du message
        }
        else {paquet->donnee = NULL;} //Sinon on signal qu'il n'y a pas de donnes suplmentaires
        prec->suivant = paquet; //On ajoute le nouveau paquet  liste des paquets  traiter
        prec = paquet; //Le dernier paquet reu est celui-ci
    }
    j->ecoute = 0;
    return 0;
}

void supprimer_joueur(t_reseau *res, long i)
{
    if(res->joueurs[i].ecoute != -1) //S'il y a quelque chose  supprimer
    {
        communiquer(ERREUR_DECO, 0, NULL, res->joueurs[i]);
        if(res->joueurs[i].ecoute == 1) {SDL_KillThread(res->joueurs[i].thread_id);} //Arrt du thread de rception
        res->joueurs[i].thread_id = NULL; //Le thread est arrt
        supprimer_paquets(res->joueurs[i].paquets); //Supprime les paquets en attente de traitement
        res->joueurs[i].paquets = NULL;
        SDLNet_TCP_Close(res->joueurs[i].socket);
        res->joueurs[i].socket = NULL; //On remet le socket  NULL pour accepter un autre client  sa place
        res->joueurs[i].pret = 0;
        res->joueurs[i].ecoute = -1;
        if(!res->chargee && res->pseudo[i]) //Si la partie n'a pas t charge depuis un fichier on libre le pseudo
        {
          free(res->pseudo[i]);
          res->pseudo[i] = NULL;
        }
    }
    return;
}

void supprimer_paquets(t_paquet *paquet)
{
    if(paquet->suivant != NULL) {supprimer_paquets(paquet->suivant);} //S'il y a d'autres paquets, on les supprime
    if(paquet->taille != 0) {free(paquet->donnee);} //S'il y a des donnes  supprimer, on supprime
    free(paquet); //On supprime enfin la structure
    return;
}

void communiquer(type_message type, long taille, char *donnee, t_joueur joueur)
{
    char *paquet; //Stockera le paquet  envoyer

    paquet = (char *)malloc(taille + 8); //On alloue donc la mmoire ncssaire
    if(paquet == NULL) {return;}
    SDLNet_Write32(type, paquet); //On crit le type dans l'odre pour le rseau
    SDLNet_Write32(taille, paquet + 4); //On crit la taille des donnes dans l'odre pour le rseau
    memcpy(paquet + 8, donnee, taille); //On crit enfin les donnes du message
    SDL_Delay(1);
    if(joueur.ecoute == 1) {SDLNet_TCP_Send(joueur.socket, paquet, taille + 8);} //On envoie le paquet si la connexion est toujours tablie
    free(paquet);
}
